// ------------------------------------
// GUI example project
// http://www.embeddedlightning.com/
// ------------------------------------

#include "system.h"
#include <stdlib.h>

char str[2] = {0,0};

void SysTick_Handler(void)
{
   static int cnt;

   if ( !cnt )
   {
      cnt = 50;
      GPIO_ToggleBits(GPIOG,GPIO_Pin_13);
      GPIO_ToggleBits(GPIOG,GPIO_Pin_14);
      UG_ConsoleSetForecolor( rand() % 0xFFFFFF );
      //UG_ConsoleSetBackcolor( rand() % 0xFFFFFF );
      UG_ConsolePutString( str );
      str[0]++;
   }
   cnt--;
}

void led_init(void)
{
   GPIO_InitTypeDef GPIO_InitStructure;

   RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_GPIOG, ENABLE);
   GPIO_InitStructure.GPIO_Pin = GPIO_Pin_13 | GPIO_Pin_14;
   GPIO_InitStructure.GPIO_Mode = GPIO_Mode_OUT;
   GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
   GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_UP;
   GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
   GPIO_Init(GPIOG, &GPIO_InitStructure);

   GPIO_ToggleBits(GPIOG,GPIO_Pin_14);
}

void systick_init( void )
{
   /* Init SysTick */
   SystemCoreClockUpdate();
   if (SysTick_Config(SystemCoreClock / 1000))
   {
      /* Capture error */
      while (1);
   }
}

UG_GUI gui;

void UG_Test( void )
{
   ltdc_show_layer( LAYER_1 );
   ltdc_draw_layer( LAYER_2 );
   UG_FillScreen( C_BLACK );
   ltdc_draw_layer( LAYER_1 );
   UG_FillScreen( C_BLACK );
   UG_FontSelect( FONT_24X40 );

   UG_ConsoleSetBackcolor( C_BLACK );

   UG_ConsoleSetForecolor( C_LIME );
   UG_ConsolePutString( "GUI v0.2\n" );

   UG_ConsoleSetForecolor( C_BLUE );
   UG_ConsolePutString( "STM32F429\n" );

   UG_ConsoleSetForecolor( C_CYAN );
   UG_ConsolePutString( "Demo ...\n" );
   UG_ConsolePutString( " \n" );

   UG_FontSelect( FONT_8X14 );
   UG_ConsoleSetForecolor( C_RED );
   UG_ConsolePutString( "www.embeddedlightning.com\n" );

   UG_FontSelect( FONT_16X26 );
   ltdc_draw_layer( LAYER_2 );
}

int main(void)
{
   SystemInit();
   delay_init();
   sdram_init();
   ltdc_init();
   ili9341_init();
   led_init();

   UG_Init(&gui,(void(*)(UG_S16,UG_S16,UG_COLOR))pset,240,320);
   UG_Test();

   systick_init();

   while(1)
   {
      ltdc_fade_to_layer( LAYER_1 );
      delay_ms( 1000 );
      ltdc_fade_to_layer( LAYER_2 );
      delay_ms( 1000 );
   }
}
